/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class MobSpawningOverTime {
    public static final Map<EntityClassification, Map<Structure<?>, List<MobSpawnInfo.Spawners>>> REPLACE_MOB_SPAWNING = new HashMap();
    public static final Map<EntityClassification, Map<Structure<?>, List<MobSpawnInfo.Spawners>>> APPEND_MOB_SPAWNING = new HashMap();

    public static void setupMobSpawningMaps() {
        Arrays.stream(EntityClassification.values()).forEach(group -> {
            Map cfr_ignored_0 = REPLACE_MOB_SPAWNING.put((EntityClassification)group, new HashMap());
        });
        Arrays.stream(EntityClassification.values()).forEach(group -> {
            Map cfr_ignored_0 = APPEND_MOB_SPAWNING.put((EntityClassification)group, new HashMap());
        });
        MobSpawningOverTime.setupMap(REPLACE_MOB_SPAWNING, RepurposedStructures.RSNaturalMobSpawningConfig.replaceMobSpawns, "replace mob spawning");
        MobSpawningOverTime.setupMap(APPEND_MOB_SPAWNING, RepurposedStructures.RSNaturalMobSpawningConfig.appendMobSpawns, "append mob spawning");
    }

    private static void setupMap(Map<EntityClassification, Map<Structure<?>, List<MobSpawnInfo.Spawners>>> mapToFillWithMobSpawns, Map<String, List<PublicMobSpawnEntry>> configMap, String errorMsg) {
        for (Map.Entry<String, List<PublicMobSpawnEntry>> configMapEntry : configMap.entrySet()) {
            if (!configMapEntry.getKey().equals("all") && !configMapEntry.getKey().contains("repurposed_structures")) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Found key that is not a repurposed structure's structure in {} config: {} Skipping that entry...", (Object)errorMsg, (Object)configMapEntry.getKey());
                continue;
            }
            if (configMapEntry.getKey().equals("all")) {
                RSStructures.RS_STRUCTURES.forEach((key, value) -> {
                    for (PublicMobSpawnEntry spawnEntry : (List)configMapEntry.getValue()) {
                        Optional entityType = Registry.field_212629_r.func_241873_b(new ResourceLocation(spawnEntry.type));
                        if (!entityType.isPresent()) {
                            if (!spawnEntry.logErrorIfNotFound) continue;
                            RepurposedStructures.LOGGER.warn("Repurposed Structures (first): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                            continue;
                        }
                        MobSpawnInfo.Spawners entryToAdd = new MobSpawnInfo.Spawners((EntityType)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                        Map structureMobMap = (Map)mapToFillWithMobSpawns.get(entryToAdd.field_242588_c.func_220339_d());
                        if (structureMobMap.containsKey(key)) {
                            ((List)structureMobMap.get(key)).add(entryToAdd);
                            continue;
                        }
                        structureMobMap.put(key, new ArrayList());
                        ((List)structureMobMap.get(key)).add(entryToAdd);
                    }
                });
                continue;
            }
            Structure structureFeature = (Structure)Registry.field_218361_B.func_82594_a(new ResourceLocation(configMapEntry.getKey()));
            if (structureFeature == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)errorMsg);
                continue;
            }
            for (PublicMobSpawnEntry spawnEntry : configMapEntry.getValue()) {
                Optional entityType = Registry.field_212629_r.func_241873_b(new ResourceLocation(spawnEntry.type));
                if (!entityType.isPresent()) {
                    if (!spawnEntry.logErrorIfNotFound) continue;
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                    continue;
                }
                MobSpawnInfo.Spawners entryToAdd = new MobSpawnInfo.Spawners((EntityType)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                Map<Structure<?>, List<MobSpawnInfo.Spawners>> structureMobMap = mapToFillWithMobSpawns.get(entryToAdd.field_242588_c.func_220339_d());
                if (structureMobMap.containsKey(structureFeature)) {
                    structureMobMap.get(structureFeature).add(entryToAdd);
                    continue;
                }
                structureMobMap.put(structureFeature, new ArrayList());
                structureMobMap.get(structureFeature).add(entryToAdd);
            }
        }
    }

    public static List<MobSpawnInfo.Spawners> getStructureSpawns(Biome biome, StructureManager accessor, EntityClassification spawnGroup, BlockPos pos) {
        if (spawnGroup != EntityClassification.CREATURE && spawnGroup != EntityClassification.MONSTER) {
            for (Map.Entry<Structure<?>, List<MobSpawnInfo.Spawners>> structureEntry : REPLACE_MOB_SPAWNING.get(spawnGroup).entrySet()) {
                if (structureEntry.getValue().isEmpty() || !accessor.func_235010_a_(pos, true, structureEntry.getKey()).func_75069_d()) continue;
                return structureEntry.getValue();
            }
        }
        ArrayList appendedSpawn = null;
        for (Map.Entry<Structure<?>, List<MobSpawnInfo.Spawners>> structureEntry : APPEND_MOB_SPAWNING.get(spawnGroup).entrySet()) {
            if (structureEntry.getValue().isEmpty() || !accessor.func_235010_a_(pos, true, structureEntry.getKey()).func_75069_d()) continue;
            if (appendedSpawn == null) {
                appendedSpawn = new ArrayList(biome.func_242433_b().func_242559_a(spawnGroup));
            }
            appendedSpawn.addAll(structureEntry.getValue());
        }
        return appendedSpawn == null ? null : new ArrayList(appendedSpawn);
    }

    public static class PublicMobSpawnEntry {
        public final String type;
        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final boolean logErrorIfNotFound;

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize, boolean logErrorIfNotFound) {
            this.type = type;
            this.weight = weight;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.logErrorIfNotFound = logErrorIfNotFound;
        }

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize) {
            this(type, weight, minGroupSize, maxGroupSize, true);
        }
    }
}

